#include "rect1.hpp"
//Helper function
void Rect::_Arrange()
{
	int temp;
	if (_left > _right)
	{
		temp = _left;
		_left = _right;
		_right = temp;
	}
	if (_bottom < _top)  //Note that in pixel land, bottom IS > top
	{
		temp = _bottom;
		_bottom = _top;
		_top = temp;
	}
}

Rect::Rect(Point p, Point q):
_left(p.x()), _bottom(p.y()),_right(q.x()),_top(q.y())
{
	_Arrange();
}

Rect::Rect(int px, int py, int qx, int qy):
_left(px), _bottom(py),_right(qx),_top(qy)
{
	_Arrange();
}

Rect::Rect(RECT r):
_left(r.left), _bottom(r.bottom),_right(r.right),_top(r.top)
{
	_Arrange();
}

Rect::Rect(HWND hwnd)
{
	RECT winrect;
	GetClientRect(hwnd, &winrect);
   *this = Rect(winrect);
}

int Rect::Clamp(Point &p) const
{
	int outcode = RECT_INSIDE;
	if (p._x < left())
	{
		p._x = left();
		outcode |= RECT_LEFT;
	}
	if (p._x > right())
	{
		p._x = right();
		outcode |= RECT_RIGHT;
	}
	if (p._y < top())
	{
		p._y = top();
		outcode |= RECT_TOP;
	}
	if (p._y > bottom())
	{
		p._y = bottom();
		outcode |= RECT_BOTTOM;
	}
	return outcode;
}

int Rect::Wrap(Point &p) const
{
	int outcode = RECT_INSIDE;
	if (p._x < _left)
	{
		outcode |= RECT_LEFT;
		p = Point(_right - _left + p._x, p._y);
	}
	if (p._x > _right)
	{
		outcode = RECT_RIGHT;
		p = Point(_left - _right + p._x, p._y);
	}
	if (p._y < _top)
	{
		outcode = RECT_TOP;
		p = Point(p._x, _bottom - _top + p._y);
	}
	if (p._y > _bottom)
	{
		outcode = RECT_BOTTOM;
		p = Point(p._x, _top - _bottom + p._y);
	}
	return outcode;
}
